param($inst_para)

#write-host "input parameter: $inst_para"

$install_path="C:\Program Files (x86)\REALTEK\Realtek Bluetooth"

if ($inst_para -eq "inst")
{
    $TRUE_FALSE=(Test-Path $install_path)
    if($TRUE_FALSE -eq "True")
    {
        Remove-Item -Recurse -Force $install_path
        #md $install_path
    }

    md $install_path
    #New-Item $install_path -type Directory

    Start-Sleep -s 1

	Write-Host $PSScriptRoot
    Copy-Item  $PSScriptRoot\x64\*.* $install_path
    Copy-Item  $PSScriptRoot\script.ps1 $install_path
    Copy-Item  $PSScriptRoot\UninstallDriver.cmd $install_path
    
	pnputil /add-driver "$install_path\rtkbtfilter.inf" /install >$install_path\pnp.log
}
elseif ($inst_para -eq "unin")
{
    $RTKBTHWID=gwmi win32_PnPSignedDriver | where {$_.Manufacturer -like "*Realtek*" -and $_.DeviceClass  -eq "Bluetooth"}
    Write-Host $RTKBTHWID
    

    $Filters=Get-WindowsDriver -Online | where {$_.ProviderName -like "*Realtek*" -and $_.ClassName -eq "Bluetooth"} 
    foreach ($filter in $Filters)
    {
        Write "Deleting filter driver..."

        pnputil /delete-driver $filter.Driver /force
    }    

    pnputil /remove-device $RTKBTHWID.DeviceID
	Start-Sleep -s 5
	pnputil /scan-devices
       
    if (Test-Path -Path $install_path -PathType Container) 
    {
        Remove-Item -Recurse -Force $install_path
    }
}

else
{
    write-host "unkown para"
}
